<?php
require_once __DIR__.'/utils.php';
require_once __DIR__.'/db.php';

if ($_SERVER['REQUEST_METHOD']==='OPTIONS') exit;
require_api_key();

$body   = json_decode(file_get_contents('php://input'), true) ?: [];
$key    = trim($body['license_key'] ?? '');
$amount = (int)($body['amount'] ?? 0);
if ($key==='' || $amount<=0) json_err(400,'MISSING_FIELDS');

try {
  $pdo = pdo_conn();
  $pdo->beginTransaction();

  $st = $pdo->prepare("SELECT Wallet_Balance FROM license_keys WHERE LicenseKey=? FOR UPDATE");
  $st->execute([$key]);
  $row = $st->fetch();
  if (!$row) { $pdo->rollBack(); json_err(404,'KEY_NOT_FOUND'); }

  $new_wallet = (int)$row['Wallet_Balance'] + $amount;
  $up = $pdo->prepare("UPDATE license_keys SET Wallet_Balance=? WHERE LicenseKey=?");
  $up->execute([$new_wallet, $key]);

  $pdo->commit();
  json_ok(['wallet'=>$new_wallet]);
} catch (Throwable $e) {
  if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
  json_err(500,'SERVER_ERROR');
}
